<?php
declare(strict_types=1);

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';

require_login();

$ver_todas = isset($_GET['todas']) ? 1 : 0;

$sql = "
  SELECT v.*, m.nome AS morador_nome, q.codigo AS quarto
  FROM visitas v
  JOIN moradores m ON m.id = v.morador_id
  JOIN quartos q ON q.id = m.quarto_id
";
if (!$ver_todas) {
  $sql .= " WHERE DATE(v.data_entrada) = CURDATE() ";
}
$sql .= " ORDER BY v.data_entrada DESC, v.id DESC LIMIT 500";

$visitas = $pdo->query($sql)->fetchAll();

require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';
?>

<div class="card">
  <div class="row" style="justify-content:space-between">
    <div>
      <div style="font-weight:900;font-size:18px">Visitas</div>
      <div style="color:var(--muted);font-size:13px;margin-top:4px">
        <?= $ver_todas ? 'Todas (até 500)' : 'Somente hoje' ?>
      </div>
    </div>
    <div class="row">
      <a class="btn" href="create.php">+ Registrar visita</a>
      <?php if ($ver_todas): ?>
        <a class="btn btn-ghost" href="index.php">Ver somente hoje</a>
      <?php else: ?>
        <a class="btn btn-ghost" href="index.php?todas=1">Ver todas</a>
      <?php endif; ?>
    </div>
  </div>

  <div class="sep"></div>

  <?php if (!$visitas): ?>
    <div style="color:var(--muted)">Nenhuma visita registrada.</div>
  <?php else: ?>
    <div class="table-wrapper">
      <table class="table">
        <thead>
          <tr>
            <th>Entrada</th>
            <th>Visitante</th>
            <th class="hide-mobile">Telefone</th>
            <th>Morador</th>
            <th class="hide-mobile">Quarto</th>
            <th>Ação</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($visitas as $v): ?>
            <tr>
              <td><?= htmlspecialchars($v['data_entrada']) ?></td>
              <td><?= htmlspecialchars($v['nome_visitante']) ?></td>
              <td class="hide-mobile"><?= htmlspecialchars((string)($v['telefone'] ?? '—')) ?></td>
              <td><?= htmlspecialchars($v['morador_nome']) ?></td>
              <td class="hide-mobile"><?= htmlspecialchars($v['quarto']) ?></td>
              <td>
                <form method="post" action="delete.php" style="display:inline" onsubmit="return confirm('Remover visita?');">
                  <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
                  <input type="hidden" name="id" value="<?= (int)$v['id'] ?>">
                  <button class="btn btn-ghost" type="submit">Remover</button>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
