<?php
declare(strict_types=1);

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';

require_login();

$q = trim((string)($_GET['q'] ?? ''));

$params = [];
$where = "1=1";
if ($q !== '') {
  $where .= " AND (nome LIKE ? OR usuario LIKE ? OR email LIKE ?)";
  $params[] = "%$q%";
  $params[] = "%$q%";
  $params[] = "%$q%";
}

$st = $pdo->prepare("
  SELECT id, nome, usuario, email, cargo, ativo, must_reset_password, last_login, created_at
  FROM usuarios
  WHERE $where
  ORDER BY id DESC
");
$st->execute($params);
$rows = $st->fetchAll();

require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';
?>

<div class="row" style="justify-content:space-between;align-items:center">
  <div>
    <div style="font-weight:900;font-size:18px">Usuários</div>
    <div style="color:var(--muted);font-size:13px;margin-top:4px">
      Cadastro e permissões (admin/recepção)
    </div>
  </div>
  <div class="row">
    <a class="btn" href="/pensionato/modules/usuarios/create.php">+ Novo usuário</a>
    <a class="btn btn-ghost" href="/pensionato/dashboard.php">Voltar</a>
  </div>
</div>

<div class="sep"></div>

<form method="get" class="row" style="gap:10px">
  <input class="input" name="q" value="<?= htmlspecialchars($q) ?>" placeholder="Buscar por nome, usuário ou email…" style="max-width:420px">
  <button class="btn btn-ghost" type="submit">Buscar</button>
  <?php if ($q !== ''): ?>
    <a class="btn btn-ghost" href="/pensionato/modules/usuarios/index.php">Limpar</a>
  <?php endif; ?>
</form>

<div class="sep"></div>

<div class="card">
  <?php if (!$rows): ?>
    <div style="color:var(--muted)">Nenhum usuário encontrado.</div>
  <?php else: ?>
    <div class="table-wrapper">
      <table class="table">
        <thead>
          <tr>
            <th>Nome</th>
            <th class="hide-mobile">Usuário</th>
            <th class="hide-mobile">Email</th>
            <th>Cargo</th>
            <th>Status</th>
            <th class="hide-mobile">1º acesso</th>
            <th class="hide-mobile">Último login</th>
            <th>Ações</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $u): ?>
            <tr>
              <td><b><?= htmlspecialchars($u['nome']) ?></b></td>
              <td class="hide-mobile"><?= htmlspecialchars($u['usuario']) ?></td>
              <td class="hide-mobile"><?= htmlspecialchars((string)($u['email'] ?? '—')) ?></td>
              <td><?= htmlspecialchars($u['cargo']) ?></td>
              <td>
                <?php if ((int)$u['ativo'] === 1): ?>
                  <span class="badge ok">Ativo</span>
                <?php else: ?>
                  <span class="badge danger">Inativo</span>
                <?php endif; ?>
              </td>
              <td class="hide-mobile">
                <?php if ((int)$u['must_reset_password'] === 1): ?>
                  <span class="badge warn">Redefinir</span>
                <?php else: ?>
                  <span class="badge ok">OK</span>
                <?php endif; ?>
              </td>
              <td class="hide-mobile"><?= htmlspecialchars((string)($u['last_login'] ?? '—')) ?></td>
              <td class="row" style="gap:8px;flex-wrap:wrap">
                <a class="btn btn-ghost" href="/pensionato/modules/usuarios/edit.php?id=<?= (int)$u['id'] ?>">Editar</a>

                <form method="post" action="/pensionato/modules/usuarios/delete.php"
                      style="display:inline" onsubmit="return confirm('Remover usuário?');">
                  <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
                  <input type="hidden" name="id" value="<?= (int)$u['id'] ?>">
                  <button class="btn danger" type="submit">Excluir</button>
                </form>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
