<?php
declare(strict_types=1);

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';

require_login();

// aqui precisamos do id do usuário logado
// ajuste se no seu sistema o ID fica em outro lugar (ex: $_SESSION['user']['id'])
$user_id = (int)($_SESSION['user_id'] ?? 0);
if ($user_id <= 0) {
  redirect('/pensionato/auth/logout.php');
}

$st = $pdo->prepare("SELECT id, nome, must_reset_password FROM usuarios WHERE id=? AND ativo=1");
$st->execute([$user_id]);
$u = $st->fetch();

if (!$u) {
  redirect('/pensionato/auth/logout.php');
}

if ((int)$u['must_reset_password'] === 0) {
  redirect('/pensionato/dashboard.php');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();

  $senha1 = (string)($_POST['senha1'] ?? '');
  $senha2 = (string)($_POST['senha2'] ?? '');

  if ($senha1 === '' || $senha2 === '') {
    flash_set('error', 'Preencha os dois campos de senha.');
    redirect('/pensionato/modules/usuarios/force_reset.php');
  }
  if ($senha1 !== $senha2) {
    flash_set('error', 'As senhas não coincidem.');
    redirect('/pensionato/modules/usuarios/force_reset.php');
  }
  if (strlen($senha1) < 6) {
    flash_set('error', 'A senha precisa ter pelo menos 6 caracteres.');
    redirect('/pensionato/modules/usuarios/force_reset.php');
  }

  $hash = password_hash($senha1, PASSWORD_BCRYPT);

  try {
    $pdo->prepare("UPDATE usuarios SET senha_hash=?, must_reset_password=0 WHERE id=?")
        ->execute([$hash, $user_id]);

    flash_set('success', 'Senha redefinida com sucesso.');
    redirect('/pensionato/dashboard.php');
  } catch (Throwable $e) {
    flash_set('error', 'Erro: ' . $e->getMessage());
    redirect('/pensionato/modules/usuarios/force_reset.php');
  }
}

require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';
?>

<div class="card" style="max-width:720px">
  <div style="font-weight:900;font-size:18px">Redefinir senha (primeiro acesso)</div>
  <div style="color:var(--muted);font-size:13px;margin-top:4px">
    Olá, <b><?= htmlspecialchars($u['nome']) ?></b>. Por segurança, redefina sua senha para continuar.
  </div>

  <div class="sep"></div>

  <form method="post" class="form-grid cols-2">
    <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">

    <div>
      <label>Nova senha</label>
      <input class="input" type="password" name="senha1" required>
    </div>

    <div>
      <label>Confirmar nova senha</label>
      <input class="input" type="password" name="senha2" required>
    </div>

    <div class="row" style="grid-column:1/-1">
      <button class="btn" type="submit">Salvar nova senha</button>
    </div>
  </form>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
