<?php
declare(strict_types=1);

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';

require_login();

function pass_hash(string $senha): string {
  return password_hash($senha, PASSWORD_BCRYPT);
}

// Obter ID do usuário a editar
$id = (int)($_GET['id'] ?? 0);
if ($id === 0) {
  flash_set('error', 'Usuário não encontrado.');
  redirect('/pensionato/modules/usuarios/index.php');
}

// Carregar dados do usuário
$stmt = $pdo->prepare("SELECT * FROM usuarios WHERE id = ?");
$stmt->execute([$id]);
$user = $stmt->fetch();

if (!$user) {
  flash_set('error', 'Usuário não encontrado.');
  redirect('/pensionato/modules/usuarios/index.php');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();

  $nome = trim((string)($_POST['nome'] ?? ''));
  $usuario = trim((string)($_POST['usuario'] ?? ''));
  $email = trim((string)($_POST['email'] ?? ''));
  $cargo = (string)($_POST['cargo'] ?? 'recepcao');
  $ativo = isset($_POST['ativo']) ? 1 : 0;
  $senha = trim((string)($_POST['senha'] ?? ''));

  if ($nome === '' || $usuario === '') {
    flash_set('error', 'Preencha nome e usuário.');
    redirect("/pensionato/modules/usuarios/edit.php?id=$id");
  }

  if (!in_array($cargo, ['admin','recepcao'], true)) $cargo = 'recepcao';

  try {
    if ($senha !== '') {
      // Se preencheu uma nova senha
      $pdo->prepare("
        UPDATE usuarios 
        SET nome = ?, usuario = ?, email = ?, senha_hash = ?, cargo = ?, ativo = ?
        WHERE id = ?
      ")->execute([
        $nome,
        $usuario,
        $email !== '' ? $email : null,
        pass_hash($senha),
        $cargo,
        $ativo,
        $id
      ]);
    } else {
      // Sem alterar a senha
      $pdo->prepare("
        UPDATE usuarios 
        SET nome = ?, usuario = ?, email = ?, cargo = ?, ativo = ?
        WHERE id = ?
      ")->execute([
        $nome,
        $usuario,
        $email !== '' ? $email : null,
        $cargo,
        $ativo,
        $id
      ]);
    }

    flash_set('success', 'Usuário atualizado com sucesso.');
    redirect('/pensionato/modules/usuarios/index.php');

  } catch (Throwable $e) {
    flash_set('error', 'Erro: ' . $e->getMessage());
    redirect("/pensionato/modules/usuarios/edit.php?id=$id");
  }
}

require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';
?>

<div class="card">
  <div class="row" style="justify-content:space-between;align-items:center">
    <div>
      <div style="font-weight:900;font-size:18px">Editar usuário</div>
      <div style="color:var(--muted);font-size:13px;margin-top:4px">
        Atualize as informações do usuário.
      </div>
    </div>
    <a class="btn btn-ghost" href="/pensionato/modules/usuarios/index.php">Voltar</a>
  </div>

  <div class="sep"></div>

  <form method="post" class="form-grid cols-2">
    <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">

    <div>
      <label>Nome</label>
      <input class="input" name="nome" value="<?= htmlspecialchars($user['nome']) ?>" required>
    </div>

    <div>
      <label>Usuário (login)</label>
      <input class="input" name="usuario" value="<?= htmlspecialchars($user['usuario']) ?>" required>
    </div>

    <div>
      <label>Email</label>
      <input class="input" name="email" placeholder="Opcional" value="<?= htmlspecialchars($user['email'] ?? '') ?>">
    </div>

    <div>
      <label>Cargo</label>
      <select class="input" name="cargo">
        <option value="recepcao" <?= $user['cargo'] === 'recepcao' ? 'selected' : '' ?>>recepcao</option>
        <option value="admin" <?= $user['cargo'] === 'admin' ? 'selected' : '' ?>>admin</option>
      </select>
    </div>

    <div>
      <label>Senha</label>
      <input class="input" type="password" name="senha" placeholder="Deixe em branco para não alterar">
      <small style="color:var(--muted)">Deixe vazio se não deseja alterar a senha.</small>
    </div>

    <div class="checkbox" style="margin-top:26px">
      <input type="checkbox" id="ativo" name="ativo" <?= $user['ativo'] == 1 ? 'checked' : '' ?>>
      <div>
        <label for="ativo" style="margin:0;color:var(--text)">Usuário ativo</label>
        <small>Se desmarcar, ele não consegue logar.</small>
      </div>
    </div>

    <div class="row" style="grid-column:1/-1">
      <button class="btn" type="submit">Salvar</button>
      <a class="btn btn-ghost" href="/pensionato/modules/usuarios/index.php">Cancelar</a>
    </div>
  </form>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
