<?php
declare(strict_types=1);

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';

require_login();
csrf_check();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  exit('Método inválido.');
}

$id = (int)($_POST['id'] ?? 0);
if ($id <= 0) {
  flash_set('error', 'ID inválido.');
  redirect('/pensionato/modules/usuarios/index.php');
}

try {
  $pdo->prepare("DELETE FROM usuarios WHERE id=?")->execute([$id]);
  flash_set('success', 'Usuário removido.');
  redirect('/pensionato/modules/usuarios/index.php');
} catch (Throwable $e) {
  flash_set('error', 'Erro: ' . $e->getMessage());
  redirect('/pensionato/modules/usuarios/index.php');
}
