<?php
declare(strict_types=1);

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';

require_login();

function pass_hash(string $senha): string {
  return password_hash($senha, PASSWORD_BCRYPT);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();

  $nome = trim((string)($_POST['nome'] ?? ''));
  $usuario = trim((string)($_POST['usuario'] ?? ''));
  $email = trim((string)($_POST['email'] ?? ''));
  $cargo = (string)($_POST['cargo'] ?? 'recepcao');
  $ativo = isset($_POST['ativo']) ? 1 : 0;

  // senha inicial obrigatória (usuário vai redefinir no primeiro login)
  $senha = (string)($_POST['senha'] ?? '');

  if ($nome === '' || $usuario === '' || $senha === '') {
    flash_set('error', 'Preencha nome, usuário e senha inicial.');
    redirect('/pensionato/modules/usuarios/create.php');
  }

  if (!in_array($cargo, ['admin','recepcao'], true)) $cargo = 'recepcao';

  try {
    $pdo->prepare("
      INSERT INTO usuarios (nome, usuario, email, senha_hash, cargo, ativo, must_reset_password)
      VALUES (?,?,?,?,?,?,1)
    ")->execute([
      $nome,
      $usuario,
      $email !== '' ? $email : null,
      pass_hash($senha),
      $cargo,
      $ativo
    ]);

    flash_set('success', 'Usuário criado. No primeiro login, ele será obrigado a redefinir a senha.');
    redirect('/pensionato/modules/usuarios/index.php');

  } catch (Throwable $e) {
    flash_set('error', 'Erro: ' . $e->getMessage());
    redirect('/pensionato/modules/usuarios/create.php');
  }
}

require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';
?>

<div class="card">
  <div class="row" style="justify-content:space-between;align-items:center">
    <div>
      <div style="font-weight:900;font-size:18px">Novo usuário</div>
      <div style="color:var(--muted);font-size:13px;margin-top:4px">
        Crie o usuário com senha inicial (ele redefinirá no primeiro acesso).
      </div>
    </div>
    <a class="btn btn-ghost" href="/pensionato/modules/usuarios/index.php">Voltar</a>
  </div>

  <div class="sep"></div>

  <form method="post" class="form-grid cols-2">
    <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">

    <div>
      <label>Nome</label>
      <input class="input" name="nome" required>
    </div>

    <div>
      <label>Usuário (login)</label>
      <input class="input" name="usuario" required>
    </div>

    <div>
      <label>Email</label>
      <input class="input" name="email" placeholder="Opcional">
    </div>

    <div>
      <label>Cargo</label>
      <select class="input" name="cargo">
        <option value="recepcao">recepcao</option>
        <option value="admin">admin</option>
      </select>
    </div>

    <div>
      <label>Senha inicial</label>
      <input class="input" type="password" name="senha" required>
      <small style="color:var(--muted)">No primeiro login o sistema obrigará a redefinir.</small>
    </div>

    <div class="checkbox" style="margin-top:26px">
      <input type="checkbox" id="ativo" name="ativo" checked>
      <div>
        <label for="ativo" style="margin:0;color:var(--text)">Usuário ativo</label>
        <small>Se desmarcar, ele não consegue logar.</small>
      </div>
    </div>

    <div class="row" style="grid-column:1/-1">
      <button class="btn" type="submit">Salvar</button>
      <a class="btn btn-ghost" href="/pensionato/modules/usuarios/index.php">Cancelar</a>
    </div>
  </form>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
