<?php
declare(strict_types=1);

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';

require_login();

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) { http_response_code(404); exit('Relatório inválido.'); }

$st = $pdo->prepare("SELECT * FROM relatorios WHERE id=?");
$st->execute([$id]);
$r = $st->fetch();
if (!$r) { http_response_code(404); exit('Relatório não encontrado.'); }

require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';
?>

<div class="row" style="justify-content:space-between;align-items:center">
  <div>
    <div style="font-weight:900;font-size:18px"><?= htmlspecialchars($r['titulo']) ?></div>
    <div style="color:var(--muted);font-size:13px;margin-top:4px">
      Autor: <b><?= htmlspecialchars((string)($r['criado_por_nome'] ?? '—')) ?></b>
      • Criado: <?= htmlspecialchars((string)$r['created_at']) ?>
      <?php if (!empty($r['updated_at'])): ?> • Atualizado: <?= htmlspecialchars((string)$r['updated_at']) ?><?php endif; ?>
    </div>
  </div>
  <div class="row">
    <a class="btn btn-ghost" href="/pensionato/modules/relatorios/index.php">Voltar</a>
    <a class="btn" href="/pensionato/modules/relatorios/edit.php?id=<?= (int)$r['id'] ?>">Editar</a>
  </div>
</div>

<div class="sep"></div>

<div class="card">
  <div style="white-space:pre-wrap;line-height:1.55">
    <?= htmlspecialchars((string)$r['conteudo']) ?>
  </div>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
