<?php
declare(strict_types=1);

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';

require_login();

$u = $_SESSION['user'] ?? [];
$roleRaw = (string)(($u['cargo'] ?? $u['nivel'] ?? '') . ' ' . ($u['role'] ?? $u['tipo'] ?? ''));
$role = mb_strtolower($roleRaw, 'UTF-8');
$role = preg_replace('/[•\|\-\_\/]+/u', ' ', $role);
$role = preg_replace('/\s+/u', ' ', $role);
$isAdmin = (strpos($role, 'administrador') !== false) || (strpos($role, 'admin') !== false);

$q = trim((string)($_GET['q'] ?? ''));

$params = [];
$where = "1=1";
if ($q !== '') {
  $where .= " AND (titulo LIKE ? OR conteudo LIKE ? OR criado_por_nome LIKE ?)";
  $params = ["%$q%", "%$q%", "%$q%"];
}

$st = $pdo->prepare("
  SELECT id, titulo, criado_por_nome, created_at, updated_at
  FROM relatorios
  WHERE $where
  ORDER BY created_at DESC, id DESC
");
$st->execute($params);
$rows = $st->fetchAll();

require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';
?>

<div class="row" style="justify-content:space-between;align-items:center">
  <div>
    <div style="font-weight:900;font-size:18px">Relatórios</div>
    <div style="color:var(--muted);font-size:13px;margin-top:4px">
      Crie relatórios completos para mostrar ao seu patrão.
    </div>
  </div>
  <div class="row">
    <a class="btn" href="/pensionato/modules/relatorios/create.php">+ Novo relatório</a>
  </div>
</div>

<div class="sep"></div>

<form method="get" class="row" style="gap:10px">
  <input class="input" name="q" value="<?= htmlspecialchars($q) ?>" placeholder="Buscar por título, texto ou autor…" style="max-width:420px">
  <button class="btn btn-ghost" type="submit">Buscar</button>
  <?php if ($q !== ''): ?>
    <a class="btn btn-ghost" href="/pensionato/modules/relatorios/index.php">Limpar</a>
  <?php endif; ?>
</form>

<div class="sep"></div>

<div class="card">
  <?php if (!$rows): ?>
    <div style="color:var(--muted)">Nenhum relatório encontrado.</div>
  <?php else: ?>
    <div class="table-wrapper">
      <table class="table">
        <thead>
          <tr>
            <th>Título</th>
            <th class="hide-mobile">Autor</th>
            <th class="hide-mobile">Criado em</th>
            <th class="hide-mobile">Atualizado</th>
            <th>Ações</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $r): ?>
            <tr>
              <td><b><?= htmlspecialchars($r['titulo']) ?></b></td>
              <td class="hide-mobile"><?= htmlspecialchars((string)($r['criado_por_nome'] ?? '—')) ?></td>
              <td class="hide-mobile"><?= htmlspecialchars((string)$r['created_at']) ?></td>
              <td class="hide-mobile"><?= htmlspecialchars((string)($r['updated_at'] ?? '—')) ?></td>
              <td class="row" style="gap:8px;flex-wrap:wrap">
                <a class="btn btn-ghost" href="/pensionato/modules/relatorios/view.php?id=<?= (int)$r['id'] ?>">Ver</a>
                <a class="btn btn-ghost" href="/pensionato/modules/relatorios/edit.php?id=<?= (int)$r['id'] ?>">Editar</a>

                <?php if ($isAdmin): ?>
                  <form method="post" action="/pensionato/modules/relatorios/delete.php" style="display:inline"
                        onsubmit="return confirm('Excluir?');">
                    <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
                    <input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
                    <button class="btn danger" type="submit">Excluir</button>
                  </form>
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
