<?php
declare(strict_types=1);

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';

require_login();
csrf_check();

$u = $_SESSION['user'] ?? [];
$roleRaw = (string)(($u['cargo'] ?? $u['nivel'] ?? '') . ' ' . ($u['role'] ?? $u['tipo'] ?? ''));
$role = mb_strtolower($roleRaw, 'UTF-8');
$role = preg_replace('/[•\|\-\_\/]+/u', ' ', $role);
$role = preg_replace('/\s+/u', ' ', $role);
$isAdmin = (strpos($role, 'administrador') !== false) || (strpos($role, 'admin') !== false);

if (!$isAdmin) {
  http_response_code(403);
  exit('Acesso negado.');
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  exit('Método inválido.');
}

$id = (int)($_POST['id'] ?? 0);
if ($id <= 0) {
  flash_set('error','ID inválido.');
  redirect('/pensionato/modules/relatorios/index.php');
}

try {
  $pdo->prepare("DELETE FROM relatorios WHERE id=?")->execute([$id]);
  flash_set('success','Relatório excluído.');
  redirect('/pensionato/modules/relatorios/index.php');
} catch (Throwable $e) {
  flash_set('error','Erro: ' . $e->getMessage());
  redirect('/pensionato/modules/relatorios/index.php');
}
