<?php
declare(strict_types=1);

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';

require_login();

$u = $_SESSION['user'] ?? [];
$user_id = (int)($u['id'] ?? ($_SESSION['user_id'] ?? 0));
$user_nome = (string)($u['nome'] ?? '—');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();

  $titulo = trim((string)($_POST['titulo'] ?? ''));
  $conteudo = trim((string)($_POST['conteudo'] ?? ''));

  if ($titulo === '' || $conteudo === '') {
    flash_set('error', 'Informe título e conteúdo.');
    redirect('/pensionato/modules/relatorios/create.php');
  }

  try {
    $pdo->prepare("
      INSERT INTO relatorios (titulo, conteudo, criado_por, criado_por_nome)
      VALUES (?,?,?,?)
    ")->execute([$titulo, $conteudo, $user_id ?: null, $user_nome ?: null]);

    $id = (int)$pdo->lastInsertId();
    flash_set('success', 'Relatório criado.');
    redirect('/pensionato/modules/relatorios/view.php?id=' . $id);
  } catch (Throwable $e) {
    flash_set('error', 'Erro: ' . $e->getMessage());
    redirect('/pensionato/modules/relatorios/create.php');
  }
}

require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';
?>

<div class="card">
  <div class="row" style="justify-content:space-between;align-items:center">
    <div>
      <div style="font-weight:900;font-size:18px">Novo relatório</div>
      <div style="color:var(--muted);font-size:13px;margin-top:4px">Escreva completo para mostrar ao patrão.</div>
    </div>
    <a class="btn btn-ghost" href="/pensionato/modules/relatorios/index.php">Voltar</a>
  </div>

  <div class="sep"></div>

  <form method="post" class="form-grid cols-1">
    <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">

    <div>
      <label>Título</label>
      <input class="input" name="titulo" required>
    </div>

    <div>
      <label>Conteúdo (relatório completo)</label>
      <textarea class="input" name="conteudo" rows="14" required></textarea>
      <div style="color:var(--muted);font-size:12px;margin-top:6px">
        Dica: escreva data, ocorrências, nomes, valores e conclusão.
      </div>
    </div>

    <div class="row">
      <button class="btn" type="submit">Salvar</button>
      <a class="btn btn-ghost" href="/pensionato/modules/relatorios/index.php">Cancelar</a>
    </div>
  </form>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
