<?php
declare(strict_types=1);
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';
require_login();

$rows = $pdo->query("SELECT * FROM quartos ORDER BY andar, codigo")->fetchAll();

require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';
?>
<div class="row" style="justify-content:space-between">
  <div>
    <div style="font-weight:900;font-size:18px">Quartos</div>
    <div style="color:var(--muted);font-size:13px">Cadastro e ocupação</div>
  </div>
  <a class="btn" href="create.php">+ Novo quarto</a>
</div>

<div class="sep"></div>

<div class="card">
  <div class="table-wrapper">
    <table class="table">
      <thead>
        <tr>
          <th>Código</th>
          <th class="hide-mobile">Andar</th>
          <th class="hide-mobile">Banheiro</th>
          <th>Status</th>
          <th>Ações</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $q): ?>
          <tr>
            <td><?= htmlspecialchars($q['codigo']) ?></td>
            <td class="hide-mobile"><?= (int)$q['andar'] ?>º</td>
            <td class="hide-mobile"><?= (int)$q['banheiro_privativo'] ? 'Privativo' : 'Compartilhado' ?></td>
            <td>
              <?php if ($q['status'] === 'alugado'): ?>
                <span class="badge warn">Alugado</span>
              <?php else: ?>
                <span class="badge ok">Disponível</span>
              <?php endif; ?>
            </td>
            <td class="row">
              <a class="btn btn-ghost" href="edit.php?id=<?= (int)$q['id'] ?>">Editar</a>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
