<?php
declare(strict_types=1);
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';
require_login();
csrf_check();

$id = (int)($_GET['id'] ?? 0);
$st = $pdo->prepare("SELECT * FROM quartos WHERE id=?");
$st->execute([$id]);
$q = $st->fetch();
if (!$q) { http_response_code(404); exit('Quarto não encontrado.'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $codigo = strtoupper(trim((string)($_POST['codigo'] ?? '')));
  $andar = (int)($_POST['andar'] ?? 0);
  $banheiro = isset($_POST['banheiro_privativo']) ? 1 : 0;
  $status = in_array($_POST['status'] ?? '', ['disponivel','alugado'], true) ? $_POST['status'] : $q['status'];

  $up = $pdo->prepare("UPDATE quartos SET codigo=?, andar=?, banheiro_privativo=?, status=? WHERE id=?");
  try {
    $up->execute([$codigo, $andar, $banheiro, $status, $id]);
    flash_set('success', 'Quarto atualizado.');
    redirect('index.php');
  } catch (Throwable $e) {
    flash_set('error', 'Erro: ' . $e->getMessage());
    redirect('edit.php?id=' . $id);
  }
}

require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';
?>
<div class="card">
  <div style="font-weight:900;font-size:18px">Editar quarto <?= htmlspecialchars($q['codigo']) ?></div>
  <div class="sep"></div>
  <form method="post" class="form-grid cols-2">
    <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
    <div>
      <label>Código</label>
      <input class="input" name="codigo" value="<?= htmlspecialchars($q['codigo']) ?>" required>
    </div>
    <div>
      <label>Andar</label>
      <input class="input" type="number" name="andar" min="1" value="<?= (int)$q['andar'] ?>" required>
    </div>
    <div>
      <label>Status</label>
      <select class="input" name="status">
        <option value="disponivel" <?= $q['status']==='disponivel'?'selected':'' ?>>Disponível</option>
        <option value="alugado" <?= $q['status']==='alugado'?'selected':'' ?>>Alugado</option>
      </select>
    </div>
    <div class="checkbox" style="grid-column:1/-1">
      <input type="checkbox" name="banheiro_privativo" id="bp" <?= (int)$q['banheiro_privativo']?'checked':'' ?>>
      <div>
        <label for="bp" style="margin:0;color:var(--text)">Banheiro privativo (no quarto)</label>
        <small>Marque se o quarto possui banheiro privativo.</small>
      </div>
    </div>
    <div class="row" style="grid-column:1/-1">
      <button class="btn" type="submit">Salvar</button>
      <a class="btn btn-ghost" href="index.php">Voltar</a>
    </div>
  </form>
</div>
<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
