<?php
declare(strict_types=1);
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';
require_login();
csrf_check();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $codigo = strtoupper(trim((string)($_POST['codigo'] ?? '')));
  $andar = (int)($_POST['andar'] ?? 0);
  $banheiro = isset($_POST['banheiro_privativo']) ? 1 : 0;

  if ($codigo === '' || $andar <= 0) {
    flash_set('error', 'Informe código e andar.');
    redirect('create.php');
  }
  $st = $pdo->prepare("INSERT INTO quartos (codigo, andar, banheiro_privativo, status) VALUES (?,?,?, 'disponivel')");
  try {
    $st->execute([$codigo, $andar, $banheiro]);
    flash_set('success', 'Quarto cadastrado.');
    redirect('index.php');
  } catch (Throwable $e) {
    flash_set('error', 'Erro: ' . $e->getMessage());
    redirect('create.php');
  }
}

require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';
?>
<div class="card">
  <div style="font-weight:900;font-size:18px">Novo quarto</div>
  <div class="sep"></div>
  <form method="post" class="form-grid cols-2">
    <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
    <div>
      <label>Código (letras/números)</label>
      <input class="input" name="codigo" placeholder="Ex: A1, B02, 201" required>
    </div>
    <div>
      <label>Andar</label>
      <input class="input" type="number" name="andar" min="1" required>
    </div>
    <div class="checkbox" style="grid-column:1/-1">
      <input type="checkbox" name="banheiro_privativo" id="bp">
      <div>
        <label for="bp" style="margin:0;color:var(--text)">Banheiro privativo (no quarto)</label>
        <small>Marque se o quarto possui banheiro privativo.</small>
      </div>
    </div>
    <div class="row" style="grid-column:1/-1">
      <button class="btn" type="submit">Salvar</button>
      <a class="btn btn-ghost" href="index.php">Cancelar</a>
    </div>
  </form>
</div>
<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
