<?php
declare(strict_types=1);
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';
require_login();

$morador_id = (int)($_GET['morador_id'] ?? 0);

$params = [];
$where = "";
if ($morador_id > 0) {
  $where = "WHERE p.morador_id=?";
  $params[] = $morador_id;
}

$st = $pdo->prepare("
  SELECT p.*, m.nome, q.codigo AS quarto_codigo
  FROM pagamentos p
  JOIN moradores m ON m.id=p.morador_id
  JOIN quartos q ON q.id=m.quarto_id
  $where
  ORDER BY p.data_pagamento DESC, p.id DESC
  LIMIT 200
");
$st->execute($params);
$rows = $st->fetchAll();

$moradores = $pdo->query("SELECT id, nome FROM moradores WHERE ativo=1 ORDER BY nome")->fetchAll();

require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';
?>
<div class="row" style="justify-content:space-between">
  <div>
    <div style="font-weight:900;font-size:18px">Pagamentos</div>
    <div style="color:var(--muted);font-size:13px">Entrada, mensalidade e outros</div>
  </div>
  <div class="row">
    <a class="btn" href="create.php">+ Pagamento mensal</a>
    <a class="btn btn-ghost" href="entrada.php">+ Entrada / Outro</a>
  </div>
</div>

<div class="sep"></div>

<div class="card">
  <form method="get" class="row">
    <div style="min-width:320px;flex:1">
      <label>Filtrar por morador</label>
      <select class="input" name="morador_id" onchange="this.form.submit()">
        <option value="0">Todos</option>
        <?php foreach ($moradores as $m): ?>
          <option value="<?= (int)$m['id'] ?>" <?= $morador_id===(int)$m['id']?'selected':'' ?>><?= htmlspecialchars($m['nome']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <a class="btn btn-ghost" href="index.php">Limpar</a>
  </form>
</div>

<div class="sep"></div>

<div class="card">
  <div class="table-wrapper">
    <table class="table">
      <thead>
        <tr>
          <th>Data</th>
          <th>Morador</th>
          <th class="hide-mobile">Quarto</th>
          <th class="hide-mobile">Tipo</th>
          <th class="hide-mobile">Ref</th>
          <th>Base</th>
          <th class="hide-mobile">Multa</th>
          <th>Total</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $p): ?>
          <tr>
            <td><?= htmlspecialchars($p['data_pagamento']) ?></td>
            <td><?= htmlspecialchars($p['nome']) ?></td>
            <td class="hide-mobile"><?= htmlspecialchars($p['quarto_codigo']) ?></td>
            <td class="hide-mobile"><?= htmlspecialchars($p['tipo']) ?></td>
            <td class="hide-mobile"><?= $p['tipo']==='mensalidade' ? sprintf('%02d/%d',(int)$p['referencia_mes'],(int)$p['referencia_ano']) : '—' ?></td>
            <td><?= money((float)$p['valor_base']) ?></td>
            <td class="hide-mobile"><?= money((float)$p['multa']) ?></td>
            <td><b><?= money((float)$p['total']) ?></b></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
