<?php
declare(strict_types=1);
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';
require_login();
csrf_check();

$moradores = $pdo->query("SELECT id, nome FROM moradores WHERE ativo=1 ORDER BY nome")->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $morador_id = (int)($_POST['morador_id'] ?? 0);
  $tipo = in_array($_POST['tipo'] ?? '', ['entrada','outro'], true) ? $_POST['tipo'] : 'outro';
  $data = (string)($_POST['data_pagamento'] ?? date('Y-m-d'));
  $valor = (float)str_replace(',', '.', (string)($_POST['valor'] ?? '0'));
  $forma = trim((string)($_POST['forma'] ?? ''));
  $obs = trim((string)($_POST['observacao'] ?? ''));

  if ($morador_id <= 0 || $valor <= 0) {
    flash_set('error','Informe morador e valor.');
    redirect('entrada.php');
  }
  $pdo->prepare("INSERT INTO pagamentos (morador_id, tipo, data_pagamento, valor_base, multa, total, forma, observacao) VALUES (?,?,?,?,0,?,?,?)")
      ->execute([$morador_id, $tipo, $data, $valor, $valor, $forma ?: null, $obs ?: null]);

  flash_set('success','Pagamento registrado.');
  redirect('index.php?morador_id='.$morador_id);
}

require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';
?>
<div class="card">
  <div style="font-weight:900;font-size:18px">Entrada / Outro pagamento</div>
  <div class="sep"></div>
  <form method="post" class="form-grid cols-2">
    <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
    <div style="grid-column:1/-1">
      <label>Morador</label>
      <select class="input" name="morador_id" required>
        <option value="">Selecione…</option>
        <?php foreach ($moradores as $m): ?>
          <option value="<?= (int)$m['id'] ?>"><?= htmlspecialchars($m['nome']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div>
      <label>Tipo</label>
      <select class="input" name="tipo">
        <option value="entrada">Entrada</option>
        <option value="outro">Outro</option>
      </select>
    </div>

    <div>
      <label>Data</label>
      <input class="input" type="date" name="data_pagamento" value="<?= date('Y-m-d') ?>">
    </div>

    <div>
      <label>Valor (R$)</label>
      <input class="input" name="valor" required placeholder="Ex: 200,00">
    </div>

    <div>
      <label>Forma</label>
      <select class="input" name="forma">
        <option value="">—</option>
        <option value="pix">PIX</option>
        <option value="dinheiro">Dinheiro</option>
        <option value="cartao">Cartão</option>
        <option value="transferencia">Transferência</option>
      </select>
    </div>

    <div style="grid-column:1/-1">
      <label>Observação</label>
      <input class="input" name="observacao" placeholder="Opcional">
    </div>

    <div class="row" style="grid-column:1/-1">
      <button class="btn" type="submit">Salvar</button>
      <a class="btn btn-ghost" href="index.php">Voltar</a>
    </div>
  </form>
</div>
<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
