<?php
declare(strict_types=1);
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';
require_login();
csrf_check();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $data = (string)($_POST['data'] ?? date('Y-m-d'));
  $categoria = in_array($_POST['categoria'] ?? '', ['agua','luz','internet','outros'], true) ? $_POST['categoria'] : 'outros';
  $descricao = trim((string)($_POST['descricao'] ?? ''));
  $valor = (float)str_replace(',', '.', (string)($_POST['valor'] ?? '0'));

  if ($valor <= 0) {
    flash_set('error','Informe um valor válido.');
    redirect('despesas.php');
  }

  $pdo->prepare("INSERT INTO despesas (data, categoria, descricao, valor) VALUES (?,?,?,?)")
      ->execute([$data, $categoria, $descricao ?: null, $valor]);

  flash_set('success','Despesa registrada.');
  redirect('despesas.php');
}

$rows = $pdo->query("SELECT * FROM despesas ORDER BY data DESC, id DESC LIMIT 200")->fetchAll();

require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';
?>
<div class="row" style="justify-content:space-between">
  <div>
    <div style="font-weight:900;font-size:18px">Despesas</div>
    <div style="color:var(--muted);font-size:13px">Água, luz, internet e outros</div>
  </div>
</div>

<div class="sep"></div>

<div class="card">
  <div style="font-weight:900">Nova despesa</div>
  <div class="sep"></div>
  <form method="post" class="form-grid cols-3">
    <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
    <div>
      <label>Data</label>
      <input class="input" type="date" name="data" value="<?= date('Y-m-d') ?>">
    </div>
    <div>
      <label>Categoria</label>
      <select class="input" name="categoria">
        <option value="agua">Água</option>
        <option value="luz">Luz</option>
        <option value="internet">Internet</option>
        <option value="outros">Outros</option>
      </select>
    </div>
    <div>
      <label>Valor (R$)</label>
      <input class="input" name="valor" placeholder="Ex: 150,00" required>
    </div>
    <div style="grid-column:1/-1">
      <label>Descrição (opcional)</label>
      <input class="input" name="descricao" placeholder="Ex: Conta de luz janeiro">
    </div>
    <div class="row" style="grid-column:1/-1">
      <button class="btn" type="submit">Salvar</button>
    </div>
  </form>
</div>

<div class="sep"></div>

<table class="table">
  <thead><tr><th>Data</th><th>Categoria</th><th>Descrição</th><th>Valor</th></tr></thead>
  <tbody>
    <?php foreach ($rows as $d): ?>
      <tr>
        <td><?= htmlspecialchars($d['data']) ?></td>
        <td><?= htmlspecialchars($d['categoria']) ?></td>
        <td><?= htmlspecialchars((string)$d['descricao']) ?></td>
        <td><b><?= money((float)$d['valor']) ?></b></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
