<?php
declare(strict_types=1);

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';

require_login();

function br_to_float(string $v): float {
  $v = trim($v);
  if ($v === '') return 0.0;
  $v = str_replace('.', '', $v);
  $v = str_replace(',', '.', $v);
  return (float)$v;
}

$morador_id = (int)($_GET['morador_id'] ?? $_POST['morador_id'] ?? $_GET['id'] ?? $_POST['id'] ?? 0);

// ✅ Se não veio morador_id, mostra seletor pesquisável
if ($morador_id <= 0) {
  $moradores = $pdo->query("
    SELECT m.id, m.nome, q.codigo AS quarto
    FROM moradores m
    JOIN quartos q ON q.id = m.quarto_id
    WHERE m.ativo=1
    ORDER BY m.nome
  ")->fetchAll();

  require_once __DIR__ . '/../../includes/header.php';
  require_once __DIR__ . '/../../includes/sidebar.php';
  ?>
  <div class="card">
    <div style="font-weight:900;font-size:18px">Novo pagamento</div>
    <div style="color:var(--muted);font-size:13px;margin-top:4px">
      Selecione o morador para continuar.
    </div>

    <div class="sep"></div>

    <div class="form-grid cols-2">
      <div style="grid-column:1/-1">
        <label>Pesquisar morador</label>
        <input class="input" id="buscaMorador" placeholder="Digite o nome para filtrar…">
      </div>

      <div style="grid-column:1/-1">
        <label>Morador</label>
        <select class="input" id="moradorSelect" size="10" style="height:auto">
          <?php foreach ($moradores as $m): ?>
            <option value="<?= (int)$m['id'] ?>">
              <?= htmlspecialchars($m['nome']) ?> — Quarto <?= htmlspecialchars($m['quarto']) ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="row" style="grid-column:1/-1">
        <button class="btn" type="button" id="btnContinuar">Continuar</button>
        <a class="btn btn-ghost" href="/pensionato/dashboard.php">Voltar</a>
      </div>
    </div>
  </div>

  <script>
  (function(){
    const busca = document.getElementById('buscaMorador');
    const sel = document.getElementById('moradorSelect');
    const btn = document.getElementById('btnContinuar');
    if (!sel || !btn) return;

    const all = Array.from(sel.options).map(o => ({value:o.value, text:o.text}));
    function render(list){
      sel.innerHTML = '';
      list.forEach(item => {
        const opt = document.createElement('option');
        opt.value = item.value;
        opt.textContent = item.text;
        sel.appendChild(opt);
      });
    }

    busca.addEventListener('input', function(){
      const q = this.value.trim().toLowerCase();
      if (!q) return render(all);
      render(all.filter(o => o.text.toLowerCase().includes(q)));
    });

    btn.addEventListener('click', function(){
      const id = sel.value;
      if (!id) return alert('Selecione um morador.');
      window.location.href = 'create.php?morador_id=' + encodeURIComponent(id);
    });

    sel.addEventListener('dblclick', function(){
      const id = sel.value;
      if (!id) return;
      window.location.href = 'create.php?morador_id=' + encodeURIComponent(id);
    });
  })();
  </script>
  <?php
  require_once __DIR__ . '/../../includes/footer.php';
  exit;
}

// carrega morador
$st = $pdo->prepare("
  SELECT m.*, q.codigo AS quarto_codigo
  FROM moradores m
  JOIN quartos q ON q.id = m.quarto_id
  WHERE m.id = ?
");
$st->execute([$morador_id]);
$morador = $st->fetch();
if (!$morador) {
  http_response_code(404);
  exit('Morador não encontrado.');
}

// advertências ativas (alerta para multa)
$stA = $pdo->prepare("SELECT COUNT(*) c FROM advertencias WHERE morador_id=? AND ativa=1");
$stA->execute([$morador_id]);
$adv_ativas = (int)$stA->fetch()['c'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();

  $tipo = (string)($_POST['tipo'] ?? 'mensalidade');
  $data_pagamento = (string)($_POST['data_pagamento'] ?? date('Y-m-d'));

  $referencia_mes = (int)($_POST['referencia_mes'] ?? (int)date('m'));
  $referencia_ano = (int)($_POST['referencia_ano'] ?? (int)date('Y'));

  $estadia_gratis = ($tipo === 'mensalidade' && isset($_POST['estadia_gratis'])) ? 1 : 0;

  $forma1 = trim((string)($_POST['forma1'] ?? ''));
  $valor1 = br_to_float((string)($_POST['valor1'] ?? '0'));

  $usar2 = isset($_POST['usar_segunda_forma']) ? 1 : 0;
  $forma2 = trim((string)($_POST['forma2'] ?? ''));
  $valor2 = br_to_float((string)($_POST['valor2'] ?? '0'));

  $multa = br_to_float((string)($_POST['multa'] ?? '0'));

  $usar_desconto = ($tipo === 'mensalidade' && isset($_POST['usar_desconto'])) ? 1 : 0;
  $desconto = $usar_desconto ? br_to_float((string)($_POST['desconto'] ?? '0')) : 0.0;

  // evitar duplicidade de mensalidade
  if ($tipo === 'mensalidade') {
    $chk = $pdo->prepare("
      SELECT COUNT(*) c
      FROM pagamentos
      WHERE morador_id=? AND tipo='mensalidade' AND referencia_mes=? AND referencia_ano=?
    ");
    $chk->execute([$morador_id, $referencia_mes, $referencia_ano]);
    if ((int)$chk->fetch()['c'] > 0) {
      flash_set('error', 'Já existe mensalidade registrada para este mês/ano.');
      redirect('create.php?morador_id=' . $morador_id);
    }
  }

  if ($estadia_gratis) {
    $valor_base = 0.0;
    $multa = 0.0;
    $desconto = 0.0;
    $total = 0.0;
    $forma_final = 'isento';
    $obs = 'Mensalidade isenta (funcionário)';
  } else {
    $valor_base = $valor1 + ($usar2 ? max(0, $valor2) : 0);

    if ($desconto < 0) $desconto = 0;
    if ($desconto > $valor_base) $desconto = $valor_base;

    $total = max(0, ($valor_base - $desconto)) + max(0, $multa);

    if ($valor_base <= 0 && $multa <= 0) {
      flash_set('error', 'Informe valor (pagamento) ou multa, ou marque estadia gratuita.');
      redirect('create.php?morador_id=' . $morador_id);
    }

    $partes = [];
    if ($usar2 && $valor2 > 0) {
      $partes[] = "1ª: {$forma1}=" . number_format($valor1, 2, ',', '.');
      $partes[] = "2ª: {$forma2}=" . number_format($valor2, 2, ',', '.');
    }
    if ($usar_desconto && $desconto > 0) {
      $partes[] = "Desconto=" . number_format($desconto, 2, ',', '.');
    }

    $obs = $partes ? implode(' | ', $partes) : null;
    $forma_final = $usar2 ? 'misto' : ($forma1 ?: null);
  }

  try {
    $pdo->prepare("
      INSERT INTO pagamentos
        (morador_id, tipo, data_pagamento, referencia_mes, referencia_ano, valor_base, multa, desconto, total, forma, observacao)
      VALUES
        (?,?,?,?,?,?,?,?,?,?,?)
    ")->execute([
      $morador_id,
      $tipo,
      $data_pagamento,
      $tipo === 'mensalidade' ? $referencia_mes : null,
      $tipo === 'mensalidade' ? $referencia_ano : null,
      $valor_base,
      $multa,
      $desconto,
      $total,
      $forma_final,
      $obs
    ]);

    flash_set('success', 'Pagamento registrado: ' . money((float)$total));

    // ✅ Aqui está a correção principal: volta para o INDEX do módulo pagamentos
    redirect('/pensionato/modules/pagamentos/index.php?morador_id=' . $morador_id);

  } catch (Throwable $e) {
    flash_set('error', 'Erro: ' . $e->getMessage());
    redirect('create.php?morador_id=' . $morador_id);
  }
}

require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';
?>

<div class="card">
  <div style="font-weight:900;font-size:18px">Novo pagamento</div>
  <div style="color:var(--muted);font-size:13px;margin-top:4px">
    Morador: <b><?= htmlspecialchars($morador['nome']) ?></b> • Quarto <b><?= htmlspecialchars($morador['quarto_codigo']) ?></b>
  </div>

  <div class="sep"></div>

  <?php if ($adv_ativas > 0): ?>
    <div class="card" style="background:rgba(255,255,255,.01)">
      <b>Atenção:</b> este morador tem <b><?= $adv_ativas ?></b> advertência(s) ativa(s). Você pode aplicar multa abaixo.
    </div>
    <div class="sep"></div>
  <?php endif; ?>

  <form method="post" class="form-grid cols-2" id="formPag">
    <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">

    <div>
      <label>Tipo</label>
      <select class="input" name="tipo" id="tipo">
        <option value="mensalidade">Mensalidade</option>
        <option value="entrada">Entrada</option>
        <option value="outro">Outro</option>
      </select>
    </div>

    <div>
      <label>Data do pagamento</label>
      <input class="input" type="date" name="data_pagamento" value="<?= date('Y-m-d') ?>">
    </div>

    <div id="refMesBox">
      <label>Mês de referência</label>
      <select class="input" name="referencia_mes">
        <?php for ($m=1;$m<=12;$m++): ?>
          <option value="<?= $m ?>" <?= $m==(int)date('m')?'selected':'' ?>><?= str_pad((string)$m,2,'0',STR_PAD_LEFT) ?></option>
        <?php endfor; ?>
      </select>
    </div>

    <div id="refAnoBox">
      <label>Ano de referência</label>
      <input class="input" name="referencia_ano" value="<?= (int)date('Y') ?>">
    </div>

    <div>
      <label>Forma de pagamento (1ª)</label>
      <select class="input" name="forma1" id="forma1">
        <option value="">—</option>
        <option value="pix">PIX</option>
        <option value="dinheiro">Dinheiro</option>
        <option value="cartao">Cartão</option>
        <option value="transferencia">Transferência</option>
      </select>

      <div class="checkbox" style="margin-top:10px">
        <input type="checkbox" id="usar2" name="usar_segunda_forma">
        <div>
          <label for="usar2" style="margin:0;color:var(--text)">Adicionar segunda forma?</label>
          <small>Se marcado, informe a segunda forma e valor.</small>
        </div>
      </div>

      <div class="checkbox" style="margin-top:10px" id="descontoChkBox">
        <input type="checkbox" id="usarDesc" name="usar_desconto">
        <div>
          <label for="usarDesc" style="margin:0;color:var(--text)">Aplicar desconto (adiantamento)?</label>
          <small>Só para mensalidade.</small>
        </div>
      </div>

      <div class="checkbox" style="margin-top:10px" id="gratisChkBox">
        <input type="checkbox" id="gratis" name="estadia_gratis">
        <div>
          <label for="gratis" style="margin:0;color:var(--text)">Estadia gratuita (funcionário)</label>
          <small>Registra mensalidade isenta (total 0).</small>
        </div>
      </div>
    </div>

    <div>
      <label>Valor (1º) (R$)</label>
      <input class="input" name="valor1" id="valor1" placeholder="Ex: <?= number_format((float)$morador['valor_mensal'], 2, ',', '.') ?>">
      <div style="color:var(--muted);font-size:12px;margin-top:6px">
        Sugestão: mensalidade atual = <b><?= money((float)$morador['valor_mensal']) ?></b>
      </div>
    </div>

    <div id="segundaArea" style="display:none; grid-column:1/-1">
      <div class="card" style="background:rgba(255,255,255,.01)">
        <div style="font-weight:900">Segunda forma</div>
        <div class="sep"></div>

        <div class="form-grid cols-2">
          <div>
            <label>Forma (2ª)</label>
            <select class="input" name="forma2" id="forma2">
              <option value="">—</option>
              <option value="pix">PIX</option>
              <option value="dinheiro">Dinheiro</option>
              <option value="cartao">Cartão</option>
              <option value="transferencia">Transferência</option>
            </select>
          </div>

          <div>
            <label>Valor (2º) (R$)</label>
            <input class="input" name="valor2" id="valor2" placeholder="Ex: 50,00">
          </div>
        </div>
      </div>
    </div>

    <div id="descontoArea" style="display:none; grid-column:1/-1">
      <div class="card" style="background:rgba(255,255,255,.01)">
        <div style="font-weight:900">Desconto</div>
        <div class="sep"></div>

        <div class="form-grid cols-2">
          <div>
            <label>Valor do desconto (R$)</label>
            <input class="input" name="desconto" id="desconto" placeholder="Ex: 100,00">
          </div>
          <div style="color:var(--muted);font-size:12px;display:flex;align-items:flex-end">
            Total = (Base − Desconto) + Multa
          </div>
        </div>
      </div>
    </div>

    <div>
      <label>Multa (R$)</label>
      <input class="input" name="multa" id="multa" placeholder="Ex: 20,00">
    </div>

    <div class="row" style="grid-column:1/-1">
      <button class="btn" type="submit">Salvar</button>
      <a class="btn btn-ghost" href="/pensionato/modules/pagamentos/index.php?morador_id=<?= (int)$morador_id ?>">Cancelar</a>
    </div>
  </form>
</div>

<script>
(function () {
  const tipo = document.getElementById('tipo');
  const refMes = document.getElementById('refMesBox');
  const refAno = document.getElementById('refAnoBox');

  const chk2 = document.getElementById('usar2');
  const area2 = document.getElementById('segundaArea');

  const chkDesc = document.getElementById('usarDesc');
  const areaDesc = document.getElementById('descontoArea');
  const descontoChkBox = document.getElementById('descontoChkBox');

  const chkGratis = document.getElementById('gratis');
  const gratisChkBox = document.getElementById('gratisChkBox');

  const valor1 = document.getElementById('valor1');
  const valor2 = document.getElementById('valor2');
  const multa = document.getElementById('multa');
  const desconto = document.getElementById('desconto');
  const forma1 = document.getElementById('forma1');
  const forma2 = document.getElementById('forma2');

  function toggleRef() {
    const isMens = (tipo && tipo.value === 'mensalidade');
    if (refMes) refMes.style.display = isMens ? 'block' : 'none';
    if (refAno) refAno.style.display = isMens ? 'block' : 'none';

    if (descontoChkBox) descontoChkBox.style.display = isMens ? 'block' : 'none';
    if (gratisChkBox) gratisChkBox.style.display = isMens ? 'block' : 'none';

    if (!isMens) {
      if (chkDesc) chkDesc.checked = false;
      if (chkGratis) chkGratis.checked = false;
    }
    toggleDesconto();
    toggleGratis();
  }

  function toggle2() {
    if (!chk2 || !area2) return;
    area2.style.display = chk2.checked ? 'block' : 'none';
    if (!chk2.checked && valor2) valor2.value = '';
  }

  function toggleDesconto() {
    if (!chkDesc || !areaDesc) return;
    areaDesc.style.display = chkDesc.checked ? 'block' : 'none';
    if (!chkDesc.checked && desconto) desconto.value = '';
  }

  function toggleGratis() {
    const isOn = chkGratis && chkGratis.checked;
    [valor1, valor2, multa, desconto].forEach(el => { if (el) el.disabled = isOn; });
    [forma1, forma2].forEach(el => { if (el) el.disabled = isOn; });

    if (isOn) {
      if (chk2) chk2.checked = false;
      if (chkDesc) chkDesc.checked = false;
      toggle2();
      toggleDesconto();
      if (valor1) valor1.value = '';
      if (valor2) valor2.value = '';
      if (multa) multa.value = '';
      if (desconto) desconto.value = '';
    }
  }

  if (tipo) tipo.addEventListener('change', toggleRef);
  if (chk2) chk2.addEventListener('change', toggle2);
  if (chkDesc) chkDesc.addEventListener('change', toggleDesconto);
  if (chkGratis) chkGratis.addEventListener('change', toggleGratis);

  toggleRef();
  toggle2();
  toggleDesconto();
  toggleGratis();
})();
</script>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
