<?php
declare(strict_types=1);

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';

require_login();

function only_digits(?string $v): string {
  return preg_replace('/\D+/', '', (string)$v);
}

$q = trim((string)($_GET['q'] ?? ''));

$params = [];
$where = "m.id > 0";
if ($q !== '') {
  $where .= " AND (m.nome LIKE ? OR q.codigo LIKE ? OR m.telefone_contato LIKE ? OR m.telefone_emergencia LIKE ?)";
  $params = ["%$q%", "%$q%", "%$q%", "%$q%"];
}

$st = $pdo->prepare("
  SELECT m.*,
         q.codigo AS quarto_codigo
  FROM moradores m
  JOIN quartos q ON q.id = m.quarto_id
  WHERE $where
  ORDER BY m.ativo DESC, q.codigo ASC, m.nome ASC
");
$st->execute($params);
$rows = $st->fetchAll();

require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';
?>

<div class="row" style="justify-content:space-between;align-items:center">
  <div>
    <div style="font-weight:900;font-size:18px">Moradores</div>
    <div style="color:var(--muted);font-size:13px;margin-top:4px">Gerencie moradores e contatos rápidos</div>
  </div>
  <div class="row">
    <a class="btn" href="/pensionato/modules/moradores/create.php">+ Novo morador</a>
  </div>
</div>

<div class="sep"></div>

<form method="get" class="row" style="gap:10px">
  <input class="input" name="q" value="<?= htmlspecialchars($q) ?>" placeholder="Buscar por nome, quarto ou telefone…" style="max-width:420px">
  <button class="btn btn-ghost" type="submit">Buscar</button>
  <?php if ($q !== ''): ?>
    <a class="btn btn-ghost" href="/pensionato/modules/moradores/index.php">Limpar</a>
  <?php endif; ?>
</form>

<div class="sep"></div>

<div class="card">
  <?php if (!$rows): ?>
    <div style="color:var(--muted)">Nenhum morador encontrado.</div>
  <?php else: ?>
    <div class="table-wrapper">
      <table class="table">
        <thead>
          <tr>
            <th>Quarto</th>
            <th>Nome</th>
            <th class="hide-mobile">Contato</th>
            <th class="hide-mobile">Emergência</th>
            <th>Status</th>
            <th>Ações</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $m): ?>
            <?php
              $tel = only_digits($m['telefone_contato'] ?? '');
              $wpp = $tel ? ('https://wa.me/55' . $tel) : null;
              $tel_em = only_digits($m['telefone_emergencia'] ?? '');
              $wpp_em = $tel_em ? ('https://wa.me/55' . $tel_em) : null;
            ?>
            <tr>
              <td><b><?= htmlspecialchars((string)$m['quarto_codigo']) ?></b></td>
              <td>
                <?= htmlspecialchars((string)$m['nome']) ?>
                <?php if (!empty($m['falar_com'])): ?>
                  <div style="color:var(--muted);font-size:12px">Falar: <?= htmlspecialchars((string)$m['falar_com']) ?></div>
                <?php endif; ?>
              </td>
              <td class="hide-mobile">
                <?= htmlspecialchars((string)($m['telefone_contato'] ?? '—')) ?>
                <?php if ($wpp): ?>
                  <a class="btn btn-ghost" target="_blank" href="<?= htmlspecialchars($wpp) ?>" title="WhatsApp">💬</a>
                <?php endif; ?>
              </td>
              <td class="hide-mobile">
                <?= htmlspecialchars((string)($m['telefone_emergencia'] ?? '—')) ?>
                <?php if ($wpp_em): ?>
                  <a class="btn btn-ghost" target="_blank" href="<?= htmlspecialchars($wpp_em) ?>" title="WhatsApp emergência">🆘</a>
                <?php endif; ?>
              </td>
              <td>
                <?php if ((int)$m['ativo'] === 1): ?>
                  <span class="badge ok">Ativo</span>
                <?php else: ?>
                  <span class="badge">Encerrado</span>
                <?php endif; ?>
              </td>
              <td class="row" style="gap:8px;flex-wrap:wrap">
                <a class="btn btn-ghost" href="/pensionato/modules/moradores/view.php?id=<?= (int)$m['id'] ?>">Ver</a>
                <a class="btn btn-ghost" href="/pensionato/modules/moradores/edit.php?id=<?= (int)$m['id'] ?>">Editar</a>
                <a class="btn btn-ghost" href="/pensionato/modules/pagamentos/create.php?morador_id=<?= (int)$m['id'] ?>">Pag.</a>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  <?php endif; ?>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
