<?php
declare(strict_types=1);

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';

require_login();
csrf_check();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  exit('Método inválido.');
}

$id = (int)($_POST['id'] ?? 0);
$data_saida = (string)($_POST['data_saida'] ?? date('Y-m-d'));

if ($id <= 0) {
  flash_set('error', 'ID inválido.');
  redirect('/pensionato/modules/moradores/index.php');
}

$st = $pdo->prepare("SELECT * FROM moradores WHERE id=?");
$st->execute([$id]);
$m = $st->fetch();
if (!$m) {
  flash_set('error', 'Morador não encontrado.');
  redirect('/pensionato/modules/moradores/index.php');
}

if ((int)$m['ativo'] !== 1) {
  flash_set('info', 'Este morador já está encerrado.');
  redirect('/pensionato/modules/moradores/view.php?id=' . $id);
}

$pdo->beginTransaction();
try {
  // encerra moradia
  $pdo->prepare("UPDATE moradores SET ativo=0, data_saida=? WHERE id=?")
      ->execute([$data_saida, $id]);

  // se o quarto ficou sem moradores ativos, libera
  $st2 = $pdo->prepare("SELECT COUNT(*) c FROM moradores WHERE quarto_id=? AND ativo=1");
  $st2->execute([(int)$m['quarto_id']]);
  $c = (int)$st2->fetch()['c'];

  if ($c === 0) {
    $pdo->prepare("UPDATE quartos SET status='disponivel' WHERE id=?")
        ->execute([(int)$m['quarto_id']]);
  }

  $pdo->commit();
  flash_set('success', 'Estadia encerrada com sucesso.');
  redirect('/pensionato/modules/moradores/index.php');

} catch (Throwable $e) {
  $pdo->rollBack();
  flash_set('error', 'Erro: ' . $e->getMessage());
  redirect('/pensionato/modules/moradores/view.php?id=' . $id);
}
