<?php
declare(strict_types=1);
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';
require_login();
csrf_check();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $morador_id = (int)($_POST['morador_id'] ?? 0);
  $cadastrado = isset($_POST['cadastrado']) ? 1 : 0;

  if ($morador_id > 0) {
    $pdo->prepare("UPDATE facial_controle SET cadastrado=? WHERE morador_id=?")->execute([$cadastrado, $morador_id]);
    flash_set('success','Status facial atualizado.');
  }
  redirect('index.php');
}

$rows = $pdo->query("
  SELECT m.id, m.nome, q.codigo AS quarto_codigo, m.ativo, f.cadastrado, f.atualizado_em
  FROM moradores m
  JOIN quartos q ON q.id=m.quarto_id
  LEFT JOIN facial_controle f ON f.morador_id=m.id
  ORDER BY m.ativo DESC, q.codigo, m.nome
")->fetchAll();

require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';
?>
<div class="row" style="justify-content:space-between">
  <div>
    <div style="font-weight:900;font-size:18px">Controle Facial</div>
    <div style="color:var(--muted);font-size:13px">Apenas controle administrativo</div>
  </div>
</div>

<div class="sep"></div>

<div class="card">
  <div class="table-wrapper">
    <table class="table">
      <thead><tr><th>Morador</th><th class="hide-mobile">Quarto</th><th class="hide-mobile">Status</th><th>Facial</th><th>Ação</th></tr></thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
          <tr>
            <td><?= htmlspecialchars($r['nome']) ?></td>
            <td class="hide-mobile"><?= htmlspecialchars($r['quarto_codigo']) ?></td>
            <td class="hide-mobile"><?= (int)$r['ativo'] ? '<span class="badge ok">Ativo</span>' : '<span class="badge danger">Encerrado</span>' ?></td>
            <td><?= (int)$r['cadastrado'] ? '<span class="badge ok">✓</span>' : '<span class="badge danger">✗</span>' ?></td>
            <td>
              <form method="post" class="row" style="gap:6px">
                <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
                <input type="hidden" name="morador_id" value="<?= (int)$r['id'] ?>">
                <label class="checkbox" style="padding:6px 8px;margin:0">
                  <input type="checkbox" name="cadastrado" <?= (int)$r['cadastrado']?'checked':'' ?>>
                  <div><small>Cadastrada</small></div>
                </label>
                <button class="btn btn-ghost" type="submit">OK</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
