<?php
declare(strict_types=1);
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';
require_login();

$rows = $pdo->query("
  SELECT a.*, m.nome, q.codigo AS quarto_codigo
  FROM advertencias a
  JOIN moradores m ON m.id=a.morador_id
  JOIN quartos q ON q.id=m.quarto_id
  ORDER BY a.data DESC, a.id DESC
  LIMIT 200
")->fetchAll();

require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';
?>
<div class="row" style="justify-content:space-between">
  <div>
    <div style="font-weight:900;font-size:18px">Advertências</div>
    <div style="color:var(--muted);font-size:13px">Aviso verbal, reincidência e advertência formal (com imagem)</div>
  </div>
  <a class="btn" href="create.php">+ Nova</a>
</div>

<div class="sep"></div>

<div class="card">
  <div class="table-wrapper">
    <table class="table">
      <thead>
        <tr>
          <th>Data</th>
          <th>Morador</th>
          <th class="hide-mobile">Quarto</th>
          <th class="hide-mobile">Tipo</th>
          <th>Ativa</th>
          <th class="hide-mobile">Imagem</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $a): ?>
          <tr>
            <td><?= htmlspecialchars($a['data']) ?></td>
            <td><?= htmlspecialchars($a['nome']) ?></td>
            <td class="hide-mobile"><?= htmlspecialchars($a['quarto_codigo']) ?></td>
            <td class="hide-mobile"><?= htmlspecialchars($a['tipo']) ?></td>
            <td><?= (int)$a['ativa']?'<span class="badge warn">Sim</span>':'<span class="badge ok">Não</span>' ?></td>
            <td class="hide-mobile">
              <?php if (!empty($a['imagem_path'])): ?>
                <a class="btn btn-ghost" href="/pensionato/<?= htmlspecialchars($a['imagem_path']) ?>" target="_blank">Ver</a>
              <?php else: ?>
                <span class="badge">—</span>
              <?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
