<?php
declare(strict_types=1);
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/app.php';
require_once __DIR__ . '/../../includes/functions.php';
require_login();
csrf_check();

$morador_id = (int)($_GET['morador_id'] ?? 0);
$moradores = $pdo->query("SELECT id, nome FROM moradores WHERE ativo=1 ORDER BY nome")->fetchAll();

function gerar_imagem_advertencia(string $nome, string $quarto, string $data, string $descricao): string {
  // Requer extensão GD habilitada (normal no XAMPP/WAMP)
  $w = 1200; $h = 700;
  $img = imagecreatetruecolor($w, $h);

  $bg = imagecolorallocate($img, 14, 16, 22);
  $panel = imagecolorallocate($img, 22, 26, 35);
  $white = imagecolorallocate($img, 235, 236, 243);
  $muted = imagecolorallocate($img, 165, 174, 194);
  $accent = imagecolorallocate($img, 110, 168, 254);
  $warn = imagecolorallocate($img, 255, 212, 59);

  imagefilledrectangle($img, 0, 0, $w, $h, $bg);
  imagefilledrectangle($img, 40, 40, $w-40, $h-40, $panel);

  // Logo
  $logoPath = APP_LOGO;
  if (is_file($logoPath)) {
    $logo = @imagecreatefrompng($logoPath);
    if ($logo) {
      $lw = imagesx($logo); $lh = imagesy($logo);
      $tw = 260; $th = (int)($lh * ($tw / $lw));
      $tmp = imagecreatetruecolor($tw, $th);
      imagesavealpha($tmp, true);
      $trans = imagecolorallocatealpha($tmp, 0,0,0,127);
      imagefill($tmp,0,0,$trans);
      imagecopyresampled($tmp, $logo, 0,0,0,0, $tw, $th, $lw, $lh);
      imagecopy($img, $tmp, 70, 70, 0,0, $tw, $th);
      imagedestroy($tmp);
      imagedestroy($logo);
    }
  }

  // Fontes TTF (opcional). Se não existir, cai para fonte interna.
  $fontBold = __DIR__ . '/../../assets/fonts/DejaVuSans-Bold.ttf';
  $font = __DIR__ . '/../../assets/fonts/DejaVuSans.ttf';
  $useTtf = is_file($font) && is_file($fontBold);

  $title = "ADVERTÊNCIA";
  $subtitle = "O morador recebeu advertência e fica ciente de que o ocorrido não deverá se repetir.";

  if ($useTtf) {
    imagettftext($img, 42, 0, 70, 240, $white, $fontBold, $title);
    imagettftext($img, 18, 0, 70, 280, $muted, $font, "Data: {$data}");
    imagettftext($img, 18, 0, 70, 312, $muted, $font, "Morador: {$nome}");
    imagettftext($img, 18, 0, 70, 344, $muted, $font, "Quarto: {$quarto}");

    // linha
    imagefilledrectangle($img, 70, 372, $w-70, 374, $accent);

    // texto
    imagettftext($img, 20, 0, 70, 420, $white, $fontBold, "COMUNICADO");
    // quebra simples
    $wrap = wordwrap($subtitle, 72, "\n");
    $y = 460;
    foreach (explode("\n", $wrap) as $line) {
      imagettftext($img, 18, 0, 70, $y, $white, $font, $line);
      $y += 30;
    }

    imagettftext($img, 18, 0, 70, 580, $warn, $fontBold, "Descrição do ocorrido:");
    $wrap2 = wordwrap($descricao, 82, "\n");
    $y = 615;
    foreach (explode("\n", $wrap2) as $line) {
      if ($y > 650) break;
      imagettftext($img, 16, 0, 70, $y, $muted, $font, $line);
      $y += 26;
    }
  } else {
    // fallback
    imagestring($img, 5, 70, 210, $title, $white);
    imagestring($img, 3, 70, 250, "Data: {$data}", $muted);
    imagestring($img, 3, 70, 275, "Morador: {$nome}", $muted);
    imagestring($img, 3, 70, 300, "Quarto: {$quarto}", $muted);
    imagefilledrectangle($img, 70, 330, $w-70, 332, $accent);
    imagestring($img, 4, 70, 360, "COMUNICADO", $white);
    imagestring($img, 3, 70, 395, $subtitle, $white);
    imagestring($img, 4, 70, 460, "Descrição do ocorrido:", $warn);
  }

  if (!is_dir(UPLOADS_ADVERTENCIAS)) mkdir(UPLOADS_ADVERTENCIAS, 0777, true);
  $filename = 'advertencia_' . date('Ymd_His') . '_' . bin2hex(random_bytes(4)) . '.png';
  $path = UPLOADS_ADVERTENCIAS . '/' . $filename;

  imagepng($img, $path);
  imagedestroy($img);

  // caminho relativo pro sistema
  return 'uploads/advertencias/' . $filename;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $morador_id = (int)($_POST['morador_id'] ?? 0);
  $data = (string)($_POST['data'] ?? date('Y-m-d'));
  $tipo = in_array($_POST['tipo'] ?? '', ['verbal','reincidencia','formal'], true) ? $_POST['tipo'] : 'verbal';
  $descricao = trim((string)($_POST['descricao'] ?? ''));

  if ($morador_id <= 0 || $descricao === '') {
    flash_set('error','Informe morador e descrição.');
    redirect('create.php');
  }

  // pega quarto
  $st = $pdo->prepare("SELECT m.nome, q.codigo AS quarto_codigo FROM moradores m JOIN quartos q ON q.id=m.quarto_id WHERE m.id=?");
  $st->execute([$morador_id]);
  $info = $st->fetch();
  if (!$info) { flash_set('error','Morador inválido.'); redirect('create.php'); }

  $imgPath = null;
  if ($tipo === 'formal') {
    $imgPath = gerar_imagem_advertencia($info['nome'], $info['quarto_codigo'], $data, $descricao);
  }

  $pdo->prepare("INSERT INTO advertencias (morador_id, data, tipo, descricao, imagem_path, ativa) VALUES (?,?,?,?,?,1)")
      ->execute([$morador_id, $data, $tipo, $descricao, $imgPath]);

  flash_set('success', $tipo === 'formal' ? 'Advertência formal registrada (imagem gerada).' : 'Advertência registrada.');
  redirect('index.php');
}

require_once __DIR__ . '/../../includes/header.php';
require_once __DIR__ . '/../../includes/sidebar.php';
?>
<div class="card">
  <div style="font-weight:900;font-size:18px">Nova advertência</div>
  <div class="sep"></div>

  <form method="post" class="form-grid cols-2">
    <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">

    <div style="grid-column:1/-1">
      <label>Morador</label>
      <select class="input" name="morador_id" required>
        <option value="">Selecione…</option>
        <?php foreach ($moradores as $m): ?>
          <option value="<?= (int)$m['id'] ?>" <?= $morador_id===(int)$m['id']?'selected':'' ?>><?= htmlspecialchars($m['nome']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div>
      <label>Data</label>
      <input class="input" type="date" name="data" value="<?= date('Y-m-d') ?>">
    </div>

    <div>
      <label>Tipo</label>
      <select class="input" name="tipo">
        <option value="verbal">Aviso verbal</option>
        <option value="reincidencia">Reincidência</option>
        <option value="formal">Advertência formal (gera imagem)</option>
      </select>
    </div>

    <div style="grid-column:1/-1">
      <label>Descrição do ocorrido</label>
      <textarea class="input" name="descricao" rows="5" placeholder="Descreva o ocorrido..." required></textarea>
    </div>

    <div class="row" style="grid-column:1/-1">
      <button class="btn" type="submit">Salvar</button>
      <a class="btn btn-ghost" href="index.php">Voltar</a>
    </div>
  </form>
</div>
<?php require_once __DIR__ . '/../../includes/footer.php'; ?>
