<?php
// includes/sidebar.php
declare(strict_types=1);

require_once __DIR__ . '/functions.php';

$u = $_SESSION['user'] ?? [];

/**
 * ✅ Pega o "cargo" de forma robusta (compatível com partes antigas do sistema)
 * Tenta:
 * - $_SESSION['user']['cargo']
 * - $_SESSION['user']['nivel']
 * - $_SESSION['cargo']
 * - $_SESSION['nivel']
 * - $_SESSION['role'] / ['tipo']
 */
$rawRole =
  (string)($u['cargo'] ?? '') . ' ' .
  (string)($u['nivel'] ?? '') . ' ' .
  (string)($_SESSION['cargo'] ?? '') . ' ' .
  (string)($_SESSION['nivel'] ?? '') . ' ' .
  (string)($u['role'] ?? '') . ' ' .
  (string)($u['tipo'] ?? '') . ' ' .
  (string)($_SESSION['role'] ?? '') . ' ' .
  (string)($_SESSION['tipo'] ?? '');

$role = strtolower(trim($rawRole));
$role = preg_replace('/[•\|\-\_\/]+/', ' ', $role);
$role = preg_replace('/\s+/', ' ', $role);

/**
 * ✅ Regra oficial:
 * - admin = todas permissões
 * - recepcao = ver/cadastrar/editar (sem exclusões restritas)
 *
 * Aceita variações como:
 * - "administrador", "admin", "adm"
 */
$isAdmin = (
  strpos($role, 'admin') !== false ||
  strpos($role, 'administrador') !== false ||
  preg_match('/\badm\b/', $role)
);
?>
<aside class="sidebar">
  <div class="brand">
    <img src="/pensionato/assets/imagens/logo.png.png" alt="Logo" class="brand-logo">
    <div class="brand-text">
      <div class="brand-title"><?= htmlspecialchars(APP_NAME) ?></div>
      <div class="brand-sub">Gestão do Pensionato</div>
    </div>
  </div>

  <nav class="menu">
    <a href="/pensionato/dashboard.php" class="menu-item">Dashboard</a>
    <a href="/pensionato/modules/quartos/index.php" class="menu-item">Quartos</a>
    <a href="/pensionato/modules/moradores/index.php" class="menu-item">Moradores</a>
    <a href="/pensionato/modules/pagamentos/index.php" class="menu-item">Pagamentos</a>
    <a href="/pensionato/modules/pagamentos/despesas.php" class="menu-item">Despesas</a>
    <a href="/pensionato/modules/advertencias/index.php" class="menu-item">Advertências</a>
    <a href="/pensionato/modules/facial/index.php" class="menu-item">Controle Facial</a>

    <!-- ✅ Relatórios (para todos) -->
    <a href="/pensionato/modules/relatorios/index.php" class="menu-item">Relatórios</a>

    <!-- ✅ Usuários (somente admin / administrador) -->
    <?php if ($isAdmin): ?>
      <a href="/pensionato/modules/usuarios/index.php" class="menu-item">Usuários</a>
    <?php endif; ?>
  </nav>

  <div class="sidebar-footer">
    <div class="user-chip">
      <div class="user-chip-name"><?= htmlspecialchars((string)($u['nome'] ?? $_SESSION['nome'] ?? '—')) ?></div>
      <div class="user-chip-role">
        <?= htmlspecialchars((string)(
          $u['cargo'] ?? $u['nivel'] ?? $_SESSION['cargo'] ?? $_SESSION['nivel'] ?? '—'
        )) ?>
      </div>
    </div>
    <a class="btn btn-ghost w100" href="/pensionato/auth/logout.php">Sair</a>
  </div>
</aside>

<main class="main">
  <header class="topbar">
    <div class="topbar-title">Painel</div>
    <div class="topbar-right">
      <span class="kbd">F1</span><span class="hint">Atalhos (em breve)</span>
    </div>
  </header>

  <section class="content">
    <?php if (!empty($f)): ?>
      <div class="flash <?= htmlspecialchars($f['type']) ?>"><?= htmlspecialchars($f['msg']) ?></div>
    <?php endif; ?>
