<?php
// includes/functions.php
declare(strict_types=1);

if (session_status() !== PHP_SESSION_ACTIVE) session_start();

function csrf_token(): string {
  if (empty($_SESSION['csrf'])) {
    $_SESSION['csrf'] = bin2hex(random_bytes(16));
  }
  return $_SESSION['csrf'];
}
function csrf_check(): void {
  if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $t = $_POST['csrf'] ?? '';
    if (!hash_equals($_SESSION['csrf'] ?? '', $t)) {
      http_response_code(403);
      exit('CSRF inválido.');
    }
  }
}
function flash_set(string $type, string $msg): void {
  $_SESSION['flash'] = ['type' => $type, 'msg' => $msg];
}
function flash_get(): ?array {
  $f = $_SESSION['flash'] ?? null;
  unset($_SESSION['flash']);
  return $f;
}
function redirect(string $to): void {
  header("Location: {$to}");
  exit;
}
function require_login(): void {
  if (empty($_SESSION['user'])) redirect('/pensionato/auth/login.php');
}
function require_level(string $nivel): void {
  require_login();
  $u = $_SESSION['user'];
  if (($u['nivel'] ?? '') !== $nivel) {
    http_response_code(403);
    exit('Acesso negado.');
  }
}
