<?php
// includes/auth.php
declare(strict_types=1);
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/app.php';
require_once __DIR__ . '/functions.php';

function auth_user_by_login(PDO $pdo, string $usuario): ?array {
  $st = $pdo->prepare("SELECT id, nome, usuario, senha_hash, nivel, primeiro_login, ativo FROM usuarios WHERE usuario=? LIMIT 1");
  $st->execute([$usuario]);
  $u = $st->fetch();
  return $u ?: null;
}
function auth_load_user(PDO $pdo, int $id): ?array {
  $st = $pdo->prepare("SELECT id, nome, usuario, nivel, primeiro_login, ativo FROM usuarios WHERE id=? LIMIT 1");
  $st->execute([$id]);
  $u = $st->fetch();
  return $u ?: null;
}
