-- Banco: pensionato
-- Crie o banco no phpMyAdmin e depois importe este arquivo.
-- Charset recomendado: utf8mb4

CREATE TABLE IF NOT EXISTS usuarios (
  id INT AUTO_INCREMENT PRIMARY KEY,
  nome VARCHAR(120) NOT NULL,
  usuario VARCHAR(60) NOT NULL UNIQUE,
  senha_hash VARCHAR(255) NOT NULL,
  nivel ENUM('admin','recepcao') NOT NULL DEFAULT 'recepcao',
  primeiro_login TINYINT(1) NOT NULL DEFAULT 1,
  ativo TINYINT(1) NOT NULL DEFAULT 1,
  criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS quartos (
  id INT AUTO_INCREMENT PRIMARY KEY,
  codigo VARCHAR(20) NOT NULL UNIQUE,
  andar INT NOT NULL,
  banheiro_privativo TINYINT(1) NOT NULL DEFAULT 0,
  status ENUM('disponivel','alugado') NOT NULL DEFAULT 'disponivel',
  criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS moradores (
  id INT AUTO_INCREMENT PRIMARY KEY,
  nome VARCHAR(150) NOT NULL,
  documento VARCHAR(30) NULL,
  quarto_id INT NOT NULL,
  qtd_pessoas INT NOT NULL DEFAULT 1,
  banheiro_privativo TINYINT(1) NOT NULL DEFAULT 0,
  valor_mensal DECIMAL(10,2) NOT NULL DEFAULT 0.00,
  pagamento_entrada DECIMAL(10,2) NOT NULL DEFAULT 0.00,
  data_entrada DATE NOT NULL,
  ativo TINYINT(1) NOT NULL DEFAULT 1,
  data_saida DATE NULL,
  criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  CONSTRAINT fk_morador_quarto FOREIGN KEY (quarto_id) REFERENCES quartos(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS facial_controle (
  id INT AUTO_INCREMENT PRIMARY KEY,
  morador_id INT NOT NULL UNIQUE,
  cadastrado TINYINT(1) NOT NULL DEFAULT 0,
  atualizado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  CONSTRAINT fk_facial_morador FOREIGN KEY (morador_id) REFERENCES moradores(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS advertencias (
  id INT AUTO_INCREMENT PRIMARY KEY,
  morador_id INT NOT NULL,
  data DATE NOT NULL,
  tipo ENUM('verbal','reincidencia','formal') NOT NULL,
  descricao TEXT NOT NULL,
  imagem_path VARCHAR(255) NULL,
  ativa TINYINT(1) NOT NULL DEFAULT 1,
  criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  CONSTRAINT fk_adv_morador FOREIGN KEY (morador_id) REFERENCES moradores(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS pagamentos (
  id INT AUTO_INCREMENT PRIMARY KEY,
  morador_id INT NOT NULL,
  tipo ENUM('entrada','mensalidade','outro') NOT NULL,
  referencia_mes INT NULL,
  referencia_ano INT NULL,
  data_pagamento DATE NOT NULL,
  valor_base DECIMAL(10,2) NOT NULL DEFAULT 0.00,
  multa DECIMAL(10,2) NOT NULL DEFAULT 0.00,
  total DECIMAL(10,2) NOT NULL DEFAULT 0.00,
  forma VARCHAR(40) NULL,
  observacao VARCHAR(255) NULL,
  criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  CONSTRAINT fk_pag_morador FOREIGN KEY (morador_id) REFERENCES moradores(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS despesas (
  id INT AUTO_INCREMENT PRIMARY KEY,
  data DATE NOT NULL,
  categoria ENUM('agua','luz','internet','outros') NOT NULL DEFAULT 'outros',
  descricao VARCHAR(255) NULL,
  valor DECIMAL(10,2) NOT NULL DEFAULT 0.00,
  criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Usuário inicial (admin / admin123). No 1º login, o sistema obriga redefinir senha.
INSERT INTO usuarios (nome, usuario, senha_hash, nivel, primeiro_login, ativo)
VALUES ('Administrador', 'admin', '$2b$10$rx1DuG9sn4GehmaoNZYVQewXG2ulKCZ6KDwh5sJnRBEWEq2ZTplay', 'admin', 1, 1)
ON DUPLICATE KEY UPDATE usuario=usuario;
