<?php
// config/app.php
declare(strict_types=1);

define('APP_NAME', 'Pensionato');
define('APP_LOGO', __DIR__ . '/../assets/imagens/logo.png'); // caminho físico
define('UPLOADS_ADVERTENCIAS', __DIR__ . '/../uploads/advertencias');

// Regras de preço (valores padrão)
const PRECO = [
  'compartilhado' => [1 => 600.00, 2 => 800.00],
  'privativo'     => [1 => 1000.00, 2 => 1200.00],
];

function money(float $v): string {
  return 'R$ ' . number_format($v, 2, ',', '.');
}
