<?php
declare(strict_types=1);
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/app.php';
require_once __DIR__ . '/../includes/functions.php';

require_login();
csrf_check();

$u = $_SESSION['user'];

if ((int)($u['primeiro_login'] ?? 0) !== 1) {
  redirect('/pensionato/dashboard.php');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $senha1 = (string)($_POST['senha1'] ?? '');
  $senha2 = (string)($_POST['senha2'] ?? '');

  if (strlen($senha1) < 8) {
    flash_set('error', 'A senha precisa ter pelo menos 8 caracteres.');
    redirect('/pensionato/auth/force_password.php');
  }
  if ($senha1 !== $senha2) {
    flash_set('error', 'As senhas não conferem.');
    redirect('/pensionato/auth/force_password.php');
  }

  $hash = password_hash($senha1, PASSWORD_BCRYPT);
  $st = $pdo->prepare("UPDATE usuarios SET senha_hash=?, primeiro_login=0 WHERE id=?");
  $st->execute([$hash, (int)$u['id']]);

  // Atualiza sessão
  $_SESSION['user']['primeiro_login'] = 0;

  flash_set('success', 'Senha redefinida com sucesso. Bem-vindo!');
  redirect('/pensionato/dashboard.php');
}

$f = flash_get();
?><!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Redefinir senha • <?= htmlspecialchars(APP_NAME) ?></title>
  <link rel="stylesheet" href="/pensionato/assets/css/app.css">
</head>
<body>
  <div class="login-shell">
    <div class="login-card">
      <div class="login-title">Primeiro acesso</div>
      <div class="login-sub">Por segurança, redefina sua senha agora.</div>

      <?php if (!empty($f)): ?>
        <div class="flash <?= htmlspecialchars($f['type']) ?>" style="margin-top:12px"><?= htmlspecialchars($f['msg']) ?></div>
      <?php endif; ?>

      <form method="post" style="margin-top:12px" autocomplete="off">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars(csrf_token()) ?>">
        <div class="form-grid">
          <div>
            <label>Nova senha</label>
            <input class="input" type="password" name="senha1" required>
          </div>
          <div>
            <label>Repita a nova senha</label>
            <input class="input" type="password" name="senha2" required>
          </div>
          <button class="btn w100" type="submit">Salvar e entrar</button>
        </div>
      </form>
    </div>
  </div>
</body>
</html>
